{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:21:01 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMSystem, MMObj, MMFFile, MMWave, MMDSPObj, MMWavOut, MMRIFF, MMWaveIO;

type
  TForm1 = class(TForm)
    FastFile: TMMFastFile;
    btnPlay: TButton;
    ListBox: TListBox;
    btnStop: TButton;
    WaveOut: TMMWaveOut;
    WaveFile: TMMWaveFile;
    procedure FormCreate(Sender: TObject);
    procedure ListBoxClick(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure WaveOutStop(Sender: TObject);
    procedure WaveOutStart(Sender: TObject);
  private
    lpfh    : PFileHandle;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

// NOTE: Put a wave file in the fastfile first,
// you can do this using the fastfile editor at designtime

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
var
   i: integer;

begin
   for i := 0 to FastFile.Count-1 do
   begin
      ListBox.Items.Add(FastFile.Files[i]);
   end;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveOut.Close;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.ListBoxClick(Sender: TObject);
begin
   if not (wosPlay in WaveOut.State) then
      btnPlay.Enabled := ListBox.ItemIndex <> -1;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.btnPlayClick(Sender: TObject);
var
   lpwio: PWaveIOCB;
   Mem: Pointer;

begin
   with FastFile do
   begin
      { get a handle to the file }
      lpfh := FileOpen(Files[ListBox.ItemIndex]);
      if (lpfh <> nil) then
      begin
         { get a pointer to the file }
         Mem := FileLock(lpfh, 0, lpfh.Size);
         if (Mem <> nil) then
         begin
            { parse the memory }
            wioBuildFileInfoFromMem(lpwio,Mem,lpfh.Size);
            if (lpwio <> nil) then
            begin
               { create a wave from memory }
               WaveFile.Wave.PWaveIOInfo := lpwio;

               { start playing }
               WaveOut.Start;
            end;
         end;
      end;
   end;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.WaveOutStart(Sender: TObject);
begin
   btnPlay.Enabled := False;
   btnStop.Enabled := True;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.WaveOutStop(Sender: TObject);
begin
   btnPlay.Enabled := ListBox.ItemIndex <> -1;
   btnStop.Enabled := False;

   { reset the WaveFile }
   WaveFile.Wave.FreeWave;

   if (lpfh <> nil) then
   begin
      { unlock the memory }
      FastFile.FileUnLock(lpfh, 0, lpfh.Size);

      { close the file }
      FastFile.FileClose(lpfh);
   end;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   Waveout.Close;
end;

end.
